<?php
/*--------------------------------------------------------------------------------------------------
    GroupDTOBuilder.php 2020-01-23
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\ProductModifiers\Database\Core\DTO\Groups;

use Gambio\Shop\ProductModifiers\Groups\ValueObjects\GroupIdentifierInterface;

/**
 * Class GroupDTOBuilder
 * @package Gambio\Shop\ProductModifiers\Database\Core\DTO\Groups
 */
class GroupDTOBuilder implements GroupDTOBuilderInterface
{
    /**
     * @var GroupIdentifierInterface
     */
    protected $id;
    
    /**
     * @var string
     */
    protected $name;
    /**
     * @var string
     */
    protected $source;
    /**
     * @var string
     */
    protected $type;
    
    
    /**
     * @param GroupIdentifierInterface $id
     *
     * @return GroupDTOBuilder
     */
    public function withId(GroupIdentifierInterface $id)
    {
        $this->id = $id;
        
        return $this;
    }
    
    
    /**
     * @param string $source
     *
     * @return GroupDTOBuilder
     */
    public function withSource(string $source)
    {
        $this->source = $source;
        
        return $this;
    }
    
    
    /**
     * @param string $name
     *
     * @return GroupDTOBuilder
     */
    public function withName(string $name)
    {
        $this->name = $name;
        
        return $this;
    }
    
    
    /**
     * @param string $type
     *
     * @return GroupDTOBuilder
     */
    public function withType(string $type)
    {
        $this->type = $type;
        
        return $this;
    }
    
    
    /**
     * @return GroupDTO
     */
    public function build(): GroupDTO
    {
        $result = new GroupDTO($this->id, $this->name, $this->type, $this->source);
        
        $this->id     = null;
        $this->name   = null;
        $this->type   = null;
        $this->source = null;
        
        return $result;
    }
    
}